clc
clear all
close all

fs=20000;
dt=1/fs;
t=[0:dt:0.3]; 

%Caratteristiche segnali
phi1_deg=0;
phi2_deg=0;
phi3_deg=0;

omega1_rpm=10000;
omega2_rpm=25000;
omega3_rpm=33000;

A1=10;
A2=3;
A3=5;
noise=5;

%Conversione unitÃ  di misura
omega1=omega1_rpm*2*pi/60;
omega2=omega2_rpm*2*pi/60;
omega3=omega3_rpm*2*pi/60;

omega1_Hz=omega1_rpm/60; %cicli o giri al secondo=Hz
omega2_Hz=omega2_rpm/60;
omega3_Hz=omega3_rpm/60;

T1=1/omega1_Hz;
T2=1/omega2_Hz;
T3=1/omega3_Hz;

phi1=phi1_deg*pi/180;
phi2=phi2_deg*pi/180;
phi3=phi3_deg*pi/180;

y1=A1*cos(omega1*t+phi1);
y2=A2*cos(omega2*t+phi2);
y3=A3*cos(omega3*t+phi3);

y=y1+y2+y3+noise*rand(1,length(t));

giri=20;
sample_giro=max([T1 T2 T3])*fs;
inizio=1;
fine=inizio+sample_giro*giri;


figure
plot(t(inizio:fine),y(inizio:fine),'k','Linewidth',4),hold on
plot(t(inizio:fine),y1(inizio:fine),'b','Linewidth',6),hold on
% plot(t(inizio:fine),y2(inizio:fine),'r','Linewidth',6),hold on
% plot(t(inizio:fine),y3(inizio:fine),'g','Linewidth',6),hold on
xlabel('Time $ [s] $','interpreter','Latex'),ylabel('Amplitude $ [\mu m] $ ','interpreter','Latex')
legend('$ Signal $','$ 1^{st}  Component $','$ 2^{nd}  Component $','$ 3^{th} Component $','interpreter','Latex')
title('Time Domain','interpreter','Latex')
grid on, zoom on,
set(gca,'FontSize',32,'FontName','TimesNewRoman')

%Analisi nel dominio della frequenza
N=length(t(inizio:fine));
df=fs/N; %frequency resolution
P=fft(y(inizio:fine)); 
Pn=abs(P/N); %contenuto in frequenza normalizzato
sampleIndex = -N/2:N/2-1; %ordered index for FFT plot
f=sampleIndex*df; %x-axis index converted to ordered frequencies
freq=f(N/2:end);
freq_rpm=freq*60;
Pn_single=Pn(1:N/2+1);
Y=2*Pn_single;

% f = fs*(0:(n/2))/n;
% 
% Y = fft(xp);
% P2 = abs(Y/n); %two-sided spectrum
% Pp = P2(1:n/2+1); %single-sided spectrum
% Pp(2:end-1) = 2*Pp(2:end-1);



figure(5)
plot(freq_rpm/1000,Y,'b','Linewidth',4),hold on
xlabel(' Frequency $ \omega $ [krpm] ','interpreter','Latex'),ylabel('Magnitude $ [\mu m] $','interpreter','Latex')
legend('Spettro Grezzo','Spettro Filtrato','interpreter','Latex')
title('Frequency Domain','interpreter','Latex')
grid on, zoom on,
set(gca,'FontSize',32,'FontName','TimesNewRoman')
xlim([0 max([omega1_rpm omega2_rpm omega3_rpm])*1.2/1000])
